PSCAD 4.2.0

Settings
 {
 Id = "955649630.1144433342"
 Author = "johnn.jayas"
 Desc = "Single-Phase Thyristor Half-Wave Rectifier"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "ass3.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 60.0
  }

 }

Definitions
 {
 Module("RunTime")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,White)
   Rectangle(-29,-12,29,12)
   Text(0,27,"%:Name")
   Text(0,42,"%:Desc")
   }


  Page(A/A4,Landscape,48,[597,467],100)
   {
   }
  }
 Module("Main")
  {
  Desc = " "
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,48,[597,467],100)
   {
   -Wire-([936,162],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   0.resistor([1062,234],1,0,-1)
    {
    R = "100.0 [ohm]"
    }
   0.ground([1062,306],1,0,-1)
    {
    }
   0.datalabel([936,720],0,0,-1)
    {
    Name = "Vload"
    }
   0.pgb([972,720],0,25251344,40)
    {
    Name = "Vload"
    Group = "Load Voltage"
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-400"
    Max = "400"
    }
   -Wire-([936,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([936,756],0,0,-1)
    {
    Name = "Vsource"
    }
   0.pgb([972,756],0,25914040,60)
    {
    Name = "Vsource"
    Group = "Source Voltage"
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-400"
    Max = "400"
    }
   -Wire-([936,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([936,792],0,0,-1)
    {
    Name = "Iload"
    }
   0.pgb([972,792],0,24599216,70)
    {
    Name = "Iload"
    Group = "Load Current"
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "3.5"
    }
   -Wire-([936,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.vco([900,1098],0,0,120)
    {
    Mode = "1"
    }
   -Wire-([972,1098],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1008,1098],2,0,-1)
    {
    Name = "theta"
    }
   -Wire-([702,540],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([738,504],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.const([828,1098],0,0,110)
    {
    Name = ""
    Value = "$(freq)"
    }
   0.annotation([738,414],0,0,-1)
    {
    AL1 = "THYRISTOR FIRING PULSE"
    AL2 = "CONTROL CIRCUIT"
    }
   0.datalabel([954,126],2,0,-1)
    {
    Name = "FP1"
    }
   0.voltmetergnd([828,162],0,0,10)
    {
    Name = "Vsource"
    }
   0.datalabel([792,576],0,0,-1)
    {
    Name = "FP1"
    }
   0.annotation([702,306],0,0,-1)
    {
    AL1 = "240 kV, $(freq) Hz"
    AL2 = "AC Source"
    }
   -Wire-([774,234],0,0,-1)
    {
    Vertex="0,0;0,-72"
    }
   0.var([666,540],0,25629520,30)
    {
    Name = "Alpha Order"
    Group = "Alpha"
    Display = "0"
    Max = "175"
    Min = "5"
    Value = "93.4"
    Units = "deg"
    Collect = "1"
    }
   -Wire-([774,162],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.source_1([774,270],1,0,210)
    {
    Name = "AC Source"
    Type = "6"
    Grnd = "1"
    Spec = "0"
    Cntrl = "1"
    AC = "0"
    Vm = "240.0 [kV]"
    Tc = "0.01 [s]"
    Ph = "0.0 [deg]"
    f = "60.0 [Hz]"
    P = "0.0 [MW]"
    Q = "0.0 [MVAR]"
    R = "1.0 [ohm]"
    Rs = "1.0 [ohm]"
    Rp = "1.0 [ohm]"
    Lp = "0.1 [H]"
    R' = "1.0 [ohm]"
    L = "0.1 [H]"
    C = "1.0 [uF]"
    L' = "0.1 [H]"
    C' = "1.0 [uF]"
    CUR = ""
    }
   -Wire-([1062,162],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([936,126],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([738,504],2,0,-1)
    {
    Name = "theta"
    }
   -Sticky-([648,900],0)
    {
    Name = ""
    Font = 1
    Bounds = 648,900,828,1008
    Alignment = 0
    Style = 1
    Arrow = 128
    Color = 0,15792890
    Text = "\
This is the Voltage-Controlled Oscillator (VCO)  component. For an input in Hz, it will output a repeating, 0 to 360 degree ramp function waveform. This waveform is used for reference in the above control circuit.
"
    }
   0.datalabel([1062,792],0,0,-1)
    {
    Name = "FP1"
    }
   0.pgb([1098,810],0,24677008,190)
    {
    Name = "FP1"
    Group = "Firing Pulse"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "1.5"
    }
   -Wire-([1062,792],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1062,720],0,0,-1)
    {
    Name = "Alpha"
    }
   0.pgb([1098,720],0,24703200,50)
    {
    Name = "Alpha"
    Group = "Alpha"
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "400"
    }
   -Wire-([1062,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1062,756],0,0,-1)
    {
    Name = "theta"
    }
   0.pgb([1098,756],0,25066560,200)
    {
    Name = "theta"
    Group = "Theta"
    Display = "0"
    Scale = "1.0"
    Units = "deg"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "400"
    }
   -Wire-([1062,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([738,540],0,0,-1)
    {
    Name = "Alpha"
    }
   0.fp_int([792,504],0,0,150)
    {
    Type = "0"
    PNum = "0"
    Blck = "0"
    PFormat = "0"
    detect = "0"
    max = "360.0 [deg]"
    min = "0.0 [deg]"
    BType = "0"
    PTime = "0.005 [s]"
    }
   -Sticky-([864,450],0)
    {
    Name = ""
    Font = 1
    Bounds = 864,450,1134,594
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
Interpolated Firing Pulse Generator (Thyristor).

This component will compare the alpha order in degrees with the output theta, in degrees, from the VCO. The output firing pulse signal is an array of 2 values. The first is a 0 or 1 and represents the actual gate pulse. The second is information regarding the interpolated switching time."
    }
   0.annotation([918,252],0,0,-1)
    {
    AL1 = "HALF-WAVE"
    AL2 = "RECTIFIER"
    }
   0.datatap([1098,810],0,0,180)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Sticky-([810,90],0)
    {
    Name = ""
    Font = 1
    Bounds = 810,90,882,126
    Alignment = 1
    Style = 1
    Arrow = 128
    Color = 0,15792890
    Text = "Thyristor Component"
    }
   -Wire-([702,270],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1062,270],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.emtconst([936,1206],0,0,130)
    {
    Name = ""
    Value = "9"
    }
   0.mult([1008,1134],0,0,170)
    {
    }
   0.mult([1008,1206],5,0,160)
    {
    }
   0.const([1008,1278],3,0,140)
    {
    Name = "RMS Voltage"
    Value = "240.0"
    }
   -Wire-([1044,1134],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([810,1260],0)
    {
    Name = ""
    Font = 1
    Bounds = 810,1260,954,1350
    Alignment = 0
    Style = 1
    Arrow = 32
    Color = 0,15792890
    Text = "\
Voltage Generation Circuit

(Vpeak = RMS x Sqrt(2))"
    }
   0.datalabel([1062,1134],2,0,-1)
    {
    Name = "V"
    }
   0.datalabel([702,270],2,0,-1)
    {
    Name = "V"
    }
   0.annotation([702,342],0,0,-1)
    {
    AL1 = "v(t) = V*sin(theta)"
    AL2 = ""
    }
   0.annotation([918,990],0,0,-1)
    {
    AL1 = "SOURCE VOLTAGE"
    AL2 = "GENERATION"
    }
   -Wire-([936,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([936,864],0,0,-1)
    {
    Name = "Vrms"
    }
   0.rms-inst([1008,918],0,0,90)
    {
    Type = "1"
    Ts = "0.1 [s]"
    Scale = "1.0"
    freq = "$(freq) [Hz]"
    NSAM = "64"
    Vinit = "0.0"
    }
   -Wire-([936,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([936,918],0,0,-1)
    {
    Name = "Iload"
    }
   -Wire-([1044,918],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.pgb([972,864],0,24694104,80)
    {
    Name = "Vrms"
    Group = "Load Voltage"
    Display = "1"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "240"
    }
   0.pgb([1062,918],0,25816184,100)
    {
    Name = "Irms"
    Group = "Load Current"
    Display = "1"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.5"
    Max = "3.5"
    }
   0.peswitch([900,162],5,0,220)
    {
    L = "T"
    Type = "1"
    SNUB = "0"
    INTR = "1"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    EFVD = "0.001 [kV]"
    EBO = "1.0E5 [kV]"
    Erw = "1.0E5 [kV]"
    TEXT = "0.0 [us]"
    RD = "50000 [ohm]"
    CD = "0.05 [uF]"
    PFB = "0"
    I = ""
    It = ""
    V = ""
    Ton = ""
    Toff = ""
    Alpha = ""
    Gamma = ""
    }
   -Sticky-([90,90],0)
    {
    Name = ""
    Font = 1
    Bounds = 90,90,576,378
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
THYRISTOR CONTROLLED SINGLE-PHASE HALF-WAVE RECTIFIER

The purpose of this example is to illustrate the use of the thyristor component (part of the \"Power Electronic Switch\" component).

As shown, a simple half-wave, thyristor controlled rectifier has been constructed. The voltage source is an externally controlled, dc source, where the control signal is a sinusoid generated by the VCO below. The firing pulse control circuit is also shown. It consists of the \"Interpolated Firing Pulse\"  component, which compares a high (H) and a low (L) input. When (H) goes higher than (L), a firing pulse is ordered (FP1).

This example utilizes \"Interpolated Switching\" - a feature exclusive to EMTDC. If your firing pulse occurs between time steps, EMTDC will interpolate the switching time, allowing for much more accurate results. See the on-line help for more infrormation on Interpolated Switching."
    }
   0.annotation([1098,234],0,0,-1)
    {
    AL1 = "LOAD"
    AL2 = ""
    }
   -ControlPanel-([648,720],0)
    {
    Name = "Control Panel"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 648,720
    Extents = 0,0,216,126
    Meter(24694104)
    Meter(25816184)
    Slider(25629520)
    }
   -Sticky-([630,630],0)
    {
    Name = ""
    Font = 1
    Bounds = 630,630,738,666
    Alignment = 1
    Style = 1
    Arrow = 3
    Color = 0,15792890
    Text = "Alpha Order Slider and Control"
    }
   -Sticky-([54,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 54,18,1170,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "THYRISTOR CONTROLLED SINGLE-PHASE HALF-WAVE RECTIFIER"
    }
   -Plot-([90,882],0)
    {
    Title = "Controls"
    Draw = 1
    Area = [0,0,486,540]
    Posn = [90,882]
    Icon = [90,882]
    Extents = 0,0,486,540
    XLabel = ""
    AutoPan = "false,75"
    PGraph([0,0],[0,0,486,212],"PolyGraph")
     {
     Options = 2
     Curve(24677008,"FP1",0,,,1)
     }
    Graph([0,212],[0,0,486,265],"deg")
     {
     Options = 0
     Units = ""
     Curve(24703200,"Alpha",0,,,)
     Curve(25066560,"theta",1,,,)
     }
    }
   0.multimeter([1044,162],0,0,20)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "2"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.1 [s]"
    Freq = "$(freq) [Hz]"
    Dis = "0"
    CurI = "Iload"
    VolI = "Vload"
    P = ""
    Q = ""
    Vrms = "Vrms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Plot-([90,396],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,486,450]
    Posn = [90,396]
    Icon = [90,396]
    Extents = 0,0,486,450
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,486,194],"Voltage")
     {
     Options = 0
     Units = "kV"
     Curve(25251344,"Vload",0,,,)
     Curve(25914040,"Vsource",1,,,)
     }
    Graph([0,194],[0,0,486,193],"Current")
     {
     Options = 0
     Units = "kA"
     Curve(24599216,"Iload",0,,,)
     Curve(25816184,"Irms",1,,,)
     }
    }
   }
  }
 }

